import java.io.*;
import java.text.*;
import java.util.*;

class FileDemo {
	public static void main(String[] args) {
		byte[] arr = {1, 2, 3};

		// Verzeichnis ggf. erstellen
		String sep = File.separator;
		var ordner = "E:"+sep+"Data"+sep+"AusDir";
		var dir = new File(ordner);
		if (dir.exists()) {
			if (dir.isDirectory())
				System.out.println("Das Verzeichnis " + ordner + " existiert bereits.");
			else {
				System.out.println(ordner + " existiert, ist aber kein Verzeichnis.");
				System.exit(1);
			}
		} else
			if (dir.mkdirs())
				System.out.println("Verzeichnis " + ordner + " erstellt");
			else {
				System.out.println("Verzeichnis " + ordner + " konnte nicht erstellt werden.");
				System.exit(1);
			}

		// Datei explizit erstellen
		String name = ordner + sep + "Ausgabe.dat";
		File f = new File(name);
		if (!f.exists()) {
			try {
				f.createNewFile();
				System.out.println("Datei " + name + " erstellt");
			} catch (Exception e) {
				System.out.println("Fehler beim Erstellen der Datei " +name);
				System.exit(1);
			}
		}

		// Ausgabedatei öffnen und schreiben
		// (unter Verzicht auf die automatische Ressourcen-Freigabe von Java 7)
		FileOutputStream fos = null;
		boolean error = false;
		try {
			fos = new FileOutputStream(f);
			fos.write(arr);
			System.out.println("Daten geschrieben in Datei " + name);
		} catch (Exception e) {
			System.out.println("Fehler beim Schreiben in Datei " + name);
			e.printStackTrace();
			error = true;
		} finally {
			try {
				if (fos != null)
					fos.close();
			} catch (Exception x) {};
		}
		if (error)
			System.exit(1);

		// Über Ausgabedatei informieren
		System.out.println("\nEigenschaften der Datei " + f.getName());
		System.out.println("  Vollst. Pfad:       " + f.getAbsolutePath());
		DateFormat df = DateFormat.getInstance();
		String time = df.format(new Date(f.lastModified()));
		System.out.println("  Letzte Änderung:    " + time);
		System.out.println("  Größe in Bytes:     " + f.length());
		System.out.println("  Schreiben möglich:  " + f.canWrite()+"\n");

		// Nutzbares Speichervolumen ermitteln
		System.out.println("\nNutzbarer Speicher in " + dir.getAbsoluteFile() +
				": " + dir.getUsableSpace()/1024/1024 + " MB");

		// Attribute der Ausgabedatei ändern
		System.out.println("\nÄnderung von Attributen der Datei " + f.getName());
		try {
			var dfz = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
			Date d = dfz.parse("24.12.2084 16:15:00");
			System.out.println("  setLastModified() erfolgreich:    " + f.setLastModified(d.getTime()));
			String ntime = dfz.format(new Date(f.lastModified()));
			System.out.println("  Letzte Änderung:                  " + ntime);
			System.out.println("  setWritable(false) erfolgreich:   " + f.setWritable(false));
			System.out.println("  setWritable(true) erfolgreich:    " + f.setWritable(true) +"\n");
		} catch (Exception e) {
			e.printStackTrace();
		}


		// Verzeichnisinhalt auflisten
		var curDir = new File(".");
		File[] files = curDir.listFiles();
		System.out.println("Einträge im aktuellen Verzeichnis:");
		for (var fi : files)
			System.out.println(" " + fi.getName());
		files = curDir.listFiles(new FnFilter("iml"));
		System.out.println("\nEinträge im aktuellen Verzeichnis mit Extension .iml:");
		for (var fi : files)
			System.out.println(" " + fi.getName());

		// Datei umbenennen
		var fn = new File(ordner + sep + "Rausgabe.dat");
		if (f.renameTo(fn))
			System.out.println("\nDatei " + f.getName() + " umbenannt in " + fn.getName());
		else
			System.out.println("Fehler beim Umbenennen der Datei " + f.getName());

		// Datei löschen
		if (fn.delete())
			System.out.println("\nDatei " + fn.getName() + " gelöscht");
		else {
			System.out.println("\nFehler beim Löschen der Datei " + fn.getName());
			System.exit(1);
		}

		// Verzeichnisse löschen
		if (dir.delete()) {
			System.out.println("\nVerzeichnis " + dir.getName() + " gelöscht");
		} else
			System.out.println("\nFehler beim Löschen des Ordners"  + dir.getName());
	}
}